/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PRECO_ALT_PROGRAMADO]    Script Date: 04/02/2014 12:39:26 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_ALT_PROGRAMADO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_ALT_PROGRAMADO]
GO
GO
--EXEC P_EST_PROD_PRECO_ALT_PROGRAMADO
CREATE PROCEDURE P_EST_PROD_PRECO_ALT_PROGRAMADO 
WITH ENCRYPTION AS
/*
	Esta procedure esta sendo executada dentro da procedure de alteracao de precos.
	P_EST_PROD_PRECO_ALTERACAO
*/
SET NOCOUNT ON;

DECLARE @CD_EMP INT
DECLARE @CD_ALT_PRECO INT

DECLARE CALTPRECOALTERAR CURSOR FAST_FORWARD FOR 
select
	EST_PROD_PRECO_ALT.CD_EMP,
	EST_PROD_PRECO_ALT.CD_ALT_PRECO
from
	EST_PROD_PRECO_ALT 
WHERE
	PRECO_AGENDADO=1
	AND DT_APLICACAO <= GETDATE()
	AND NOT DT_FIM_AGENDA IS NULL
	AND APLICADO=0

OPEN CALTPRECOALTERAR
	FETCH NEXT FROM CALTPRECOALTERAR INTO 
				@CD_EMP,@CD_ALT_PRECO
	WHILE @@FETCH_STATUS = 0 
		BEGIN	
			PRINT 'P_EST_PROD_PRECO_ALT_PROGRAMADO' 
			PRINT 'CONTROLE.: ' + CONVERT(VARCHAR(20),@CD_ALT_PRECO) 		

			EXEC P_EST_PROD_PRECO_ALT_CRIAR_PROGRAMACAO @CD_EMP,@CD_ALT_PRECO
						
		FETCH NEXT FROM CALTPRECOALTERAR INTO 
						@CD_EMP,@CD_ALT_PRECO
		END
	    CLOSE CALTPRECOALTERAR
	    DEALLOCATE CALTPRECOALTERAR